package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait JobType {
  def unwrap: software.amazon.awssdk.services.snowball.model.JobType
}
object JobType {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.JobType
  ): zio.aws.snowball.model.JobType = value match {
    case software.amazon.awssdk.services.snowball.model.JobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.JobType.IMPORT =>
      val r = IMPORT
      r
    case software.amazon.awssdk.services.snowball.model.JobType.EXPORT =>
      val r = EXPORT
      r
    case software.amazon.awssdk.services.snowball.model.JobType.LOCAL_USE =>
      val r = LOCAL_USE
      r
  }
  case object unknownToSdkVersion extends zio.aws.snowball.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobType =
      software.amazon.awssdk.services.snowball.model.JobType.UNKNOWN_TO_SDK_VERSION
  }
  case object IMPORT extends zio.aws.snowball.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobType =
      software.amazon.awssdk.services.snowball.model.JobType.IMPORT
  }
  case object EXPORT extends zio.aws.snowball.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobType =
      software.amazon.awssdk.services.snowball.model.JobType.EXPORT
  }
  case object LOCAL_USE extends zio.aws.snowball.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobType =
      software.amazon.awssdk.services.snowball.model.JobType.LOCAL_USE
  }
}
