package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class KeyRange(
    beginMarker: Option[String] = None,
    endMarker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.KeyRange = {
    import KeyRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.KeyRange
      .builder()
      .optionallyWith(beginMarker.map(value => value: java.lang.String))(
        _.beginMarker
      )
      .optionallyWith(endMarker.map(value => value: java.lang.String))(
        _.endMarker
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.KeyRange.ReadOnly =
    zio.aws.snowball.model.KeyRange.wrap(buildAwsValue())
}
object KeyRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.snowball.model.KeyRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.KeyRange = zio.aws.snowball.model
      .KeyRange(beginMarker.map(value => value), endMarker.map(value => value))
    def beginMarker: Option[String]
    def endMarker: Option[String]
    def getBeginMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("beginMarker", beginMarker)
    def getEndMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endMarker", endMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.KeyRange
  ) extends zio.aws.snowball.model.KeyRange.ReadOnly {
    override val beginMarker: Option[String] =
      scala.Option(impl.beginMarker()).map(value => value: String)
    override val endMarker: Option[String] =
      scala.Option(impl.endMarker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.KeyRange
  ): zio.aws.snowball.model.KeyRange.ReadOnly = new Wrapper(impl)
}
