package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.ResourceARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LambdaResource(
    lambdaArn: Option[ResourceARN] = None,
    eventTriggers: Option[
      Iterable[zio.aws.snowball.model.EventTriggerDefinition]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.LambdaResource = {
    import LambdaResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.LambdaResource
      .builder()
      .optionallyWith(
        lambdaArn.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.lambdaArn)
      .optionallyWith(
        eventTriggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventTriggers)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.LambdaResource.ReadOnly =
    zio.aws.snowball.model.LambdaResource.wrap(buildAwsValue())
}
object LambdaResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.LambdaResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.LambdaResource =
      zio.aws.snowball.model.LambdaResource(
        lambdaArn.map(value => value),
        eventTriggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lambdaArn: Option[ResourceARN]
    def eventTriggers
        : Option[List[zio.aws.snowball.model.EventTriggerDefinition.ReadOnly]]
    def getLambdaArn: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("lambdaArn", lambdaArn)
    def getEventTriggers: ZIO[Any, AwsError, List[
      zio.aws.snowball.model.EventTriggerDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("eventTriggers", eventTriggers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.LambdaResource
  ) extends zio.aws.snowball.model.LambdaResource.ReadOnly {
    override val lambdaArn: Option[ResourceARN] = scala
      .Option(impl.lambdaArn())
      .map(value => zio.aws.snowball.model.primitives.ResourceARN(value))
    override val eventTriggers
        : Option[List[zio.aws.snowball.model.EventTriggerDefinition.ReadOnly]] =
      scala
        .Option(impl.eventTriggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.snowball.model.EventTriggerDefinition.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.LambdaResource
  ): zio.aws.snowball.model.LambdaResource.ReadOnly = new Wrapper(impl)
}
