package zio.aws.snowball.model
import java.lang.Integer
import zio.aws.snowball.model.primitives.{ListLimit, ClusterId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListClusterJobsRequest(
    clusterId: ClusterId,
    maxResults: Option[ListLimit] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest = {
    import ListClusterJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => ListLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.ListClusterJobsRequest.ReadOnly =
    zio.aws.snowball.model.ListClusterJobsRequest.wrap(buildAwsValue())
}
object ListClusterJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.ListClusterJobsRequest =
      zio.aws.snowball.model.ListClusterJobsRequest(
        clusterId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterId: ClusterId
    def maxResults: Option[ListLimit]
    def nextToken: Option[String]
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getMaxResults: ZIO[Any, AwsError, ListLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest
  ) extends zio.aws.snowball.model.ListClusterJobsRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.snowball.model.primitives.ClusterId(impl.clusterId())
    override val maxResults: Option[ListLimit] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.snowball.model.primitives.ListLimit(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest
  ): zio.aws.snowball.model.ListClusterJobsRequest.ReadOnly = new Wrapper(impl)
}
