package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListClusterJobsResponse(
    jobListEntries: Option[Iterable[zio.aws.snowball.model.JobListEntry]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse = {
    import ListClusterJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse
      .builder()
      .optionallyWith(
        jobListEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobListEntries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.ListClusterJobsResponse.ReadOnly =
    zio.aws.snowball.model.ListClusterJobsResponse.wrap(buildAwsValue())
}
object ListClusterJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.ListClusterJobsResponse =
      zio.aws.snowball.model.ListClusterJobsResponse(
        jobListEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def jobListEntries
        : Option[List[zio.aws.snowball.model.JobListEntry.ReadOnly]]
    def nextToken: Option[String]
    def getJobListEntries: ZIO[Any, AwsError, List[
      zio.aws.snowball.model.JobListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("jobListEntries", jobListEntries)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse
  ) extends zio.aws.snowball.model.ListClusterJobsResponse.ReadOnly {
    override val jobListEntries
        : Option[List[zio.aws.snowball.model.JobListEntry.ReadOnly]] = scala
      .Option(impl.jobListEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.JobListEntry.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse
  ): zio.aws.snowball.model.ListClusterJobsResponse.ReadOnly = new Wrapper(impl)
}
