package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListClustersResponse(
    clusterListEntries: Option[
      Iterable[zio.aws.snowball.model.ClusterListEntry]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.ListClustersResponse = {
    import ListClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.ListClustersResponse
      .builder()
      .optionallyWith(
        clusterListEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterListEntries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.ListClustersResponse.ReadOnly =
    zio.aws.snowball.model.ListClustersResponse.wrap(buildAwsValue())
}
object ListClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.ListClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.ListClustersResponse =
      zio.aws.snowball.model.ListClustersResponse(
        clusterListEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clusterListEntries
        : Option[List[zio.aws.snowball.model.ClusterListEntry.ReadOnly]]
    def nextToken: Option[String]
    def getClusterListEntries: ZIO[Any, AwsError, List[
      zio.aws.snowball.model.ClusterListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterListEntries", clusterListEntries)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.ListClustersResponse
  ) extends zio.aws.snowball.model.ListClustersResponse.ReadOnly {
    override val clusterListEntries
        : Option[List[zio.aws.snowball.model.ClusterListEntry.ReadOnly]] = scala
      .Option(impl.clusterListEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.ClusterListEntry.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.ListClustersResponse
  ): zio.aws.snowball.model.ListClustersResponse.ReadOnly = new Wrapper(impl)
}
