package zio.aws.snowball.model
import java.lang.Integer
import zio.aws.snowball.model.primitives.ListLimit
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCompatibleImagesRequest(
    maxResults: Option[ListLimit] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest = {
    import ListCompatibleImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ListLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.ListCompatibleImagesRequest.ReadOnly =
    zio.aws.snowball.model.ListCompatibleImagesRequest.wrap(buildAwsValue())
}
object ListCompatibleImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.ListCompatibleImagesRequest =
      zio.aws.snowball.model.ListCompatibleImagesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[ListLimit]
    def nextToken: Option[String]
    def getMaxResults: ZIO[Any, AwsError, ListLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest
  ) extends zio.aws.snowball.model.ListCompatibleImagesRequest.ReadOnly {
    override val maxResults: Option[ListLimit] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.snowball.model.primitives.ListLimit(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest
  ): zio.aws.snowball.model.ListCompatibleImagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
