package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCompatibleImagesResponse(
    compatibleImages: Option[Iterable[zio.aws.snowball.model.CompatibleImage]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse = {
    import ListCompatibleImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse
      .builder()
      .optionallyWith(
        compatibleImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.compatibleImages)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.ListCompatibleImagesResponse.ReadOnly =
    zio.aws.snowball.model.ListCompatibleImagesResponse.wrap(buildAwsValue())
}
object ListCompatibleImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.ListCompatibleImagesResponse =
      zio.aws.snowball.model.ListCompatibleImagesResponse(
        compatibleImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def compatibleImages
        : Option[List[zio.aws.snowball.model.CompatibleImage.ReadOnly]]
    def nextToken: Option[String]
    def getCompatibleImages: ZIO[Any, AwsError, List[
      zio.aws.snowball.model.CompatibleImage.ReadOnly
    ]] = AwsError.unwrapOptionField("compatibleImages", compatibleImages)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse
  ) extends zio.aws.snowball.model.ListCompatibleImagesResponse.ReadOnly {
    override val compatibleImages
        : Option[List[zio.aws.snowball.model.CompatibleImage.ReadOnly]] = scala
      .Option(impl.compatibleImages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.CompatibleImage.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse
  ): zio.aws.snowball.model.ListCompatibleImagesResponse.ReadOnly = new Wrapper(
    impl
  )
}
