package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLongTermPricingResponse(
    longTermPricingEntries: Option[
      Iterable[zio.aws.snowball.model.LongTermPricingListEntry]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse = {
    import ListLongTermPricingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse
      .builder()
      .optionallyWith(
        longTermPricingEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.longTermPricingEntries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.ListLongTermPricingResponse.ReadOnly =
    zio.aws.snowball.model.ListLongTermPricingResponse.wrap(buildAwsValue())
}
object ListLongTermPricingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.ListLongTermPricingResponse =
      zio.aws.snowball.model.ListLongTermPricingResponse(
        longTermPricingEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def longTermPricingEntries
        : Option[List[zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly]]
    def nextToken: Option[String]
    def getLongTermPricingEntries: ZIO[Any, AwsError, List[
      zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "longTermPricingEntries",
      longTermPricingEntries
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse
  ) extends zio.aws.snowball.model.ListLongTermPricingResponse.ReadOnly {
    override val longTermPricingEntries: Option[
      List[zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly]
    ] = scala
      .Option(impl.longTermPricingEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.LongTermPricingListEntry.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse
  ): zio.aws.snowball.model.ListLongTermPricingResponse.ReadOnly = new Wrapper(
    impl
  )
}
