package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.{
  JavaBoolean,
  JobId,
  Timestamp,
  LongTermPricingId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class LongTermPricingListEntry(
    longTermPricingId: Option[LongTermPricingId] = None,
    longTermPricingEndDate: Option[Timestamp] = None,
    longTermPricingStartDate: Option[Timestamp] = None,
    longTermPricingType: Option[zio.aws.snowball.model.LongTermPricingType] =
      None,
    currentActiveJob: Option[JobId] = None,
    replacementJob: Option[JobId] = None,
    isLongTermPricingAutoRenew: Option[JavaBoolean] = None,
    longTermPricingStatus: Option[String] = None,
    snowballType: Option[zio.aws.snowball.model.SnowballType] = None,
    jobIds: Option[Iterable[JobId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.LongTermPricingListEntry = {
    import LongTermPricingListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.LongTermPricingListEntry
      .builder()
      .optionallyWith(
        longTermPricingId.map(value =>
          LongTermPricingId.unwrap(value): java.lang.String
        )
      )(_.longTermPricingId)
      .optionallyWith(
        longTermPricingEndDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.longTermPricingEndDate)
      .optionallyWith(
        longTermPricingStartDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.longTermPricingStartDate)
      .optionallyWith(longTermPricingType.map(value => value.unwrap))(
        _.longTermPricingType
      )
      .optionallyWith(
        currentActiveJob.map(value => JobId.unwrap(value): java.lang.String)
      )(_.currentActiveJob)
      .optionallyWith(
        replacementJob.map(value => JobId.unwrap(value): java.lang.String)
      )(_.replacementJob)
      .optionallyWith(
        isLongTermPricingAutoRenew.map(value =>
          JavaBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.isLongTermPricingAutoRenew)
      .optionallyWith(
        longTermPricingStatus.map(value => value: java.lang.String)
      )(_.longTermPricingStatus)
      .optionallyWith(snowballType.map(value => value.unwrap))(_.snowballType)
      .optionallyWith(
        jobIds.map(value =>
          value.map { item =>
            JobId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.jobIds)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly =
    zio.aws.snowball.model.LongTermPricingListEntry.wrap(buildAwsValue())
}
object LongTermPricingListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.LongTermPricingListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.LongTermPricingListEntry =
      zio.aws.snowball.model.LongTermPricingListEntry(
        longTermPricingId.map(value => value),
        longTermPricingEndDate.map(value => value),
        longTermPricingStartDate.map(value => value),
        longTermPricingType.map(value => value),
        currentActiveJob.map(value => value),
        replacementJob.map(value => value),
        isLongTermPricingAutoRenew.map(value => value),
        longTermPricingStatus.map(value => value),
        snowballType.map(value => value),
        jobIds.map(value => value)
      )
    def longTermPricingId: Option[LongTermPricingId]
    def longTermPricingEndDate: Option[Timestamp]
    def longTermPricingStartDate: Option[Timestamp]
    def longTermPricingType: Option[zio.aws.snowball.model.LongTermPricingType]
    def currentActiveJob: Option[JobId]
    def replacementJob: Option[JobId]
    def isLongTermPricingAutoRenew: Option[JavaBoolean]
    def longTermPricingStatus: Option[String]
    def snowballType: Option[zio.aws.snowball.model.SnowballType]
    def jobIds: Option[List[JobId]]
    def getLongTermPricingId: ZIO[Any, AwsError, LongTermPricingId] =
      AwsError.unwrapOptionField("longTermPricingId", longTermPricingId)
    def getLongTermPricingEndDate: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("longTermPricingEndDate", longTermPricingEndDate)
    def getLongTermPricingStartDate: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("longTermPricingStartDate", longTermPricingStartDate)
    def getLongTermPricingType
        : ZIO[Any, AwsError, zio.aws.snowball.model.LongTermPricingType] =
      AwsError.unwrapOptionField("longTermPricingType", longTermPricingType)
    def getCurrentActiveJob: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("currentActiveJob", currentActiveJob)
    def getReplacementJob: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("replacementJob", replacementJob)
    def getIsLongTermPricingAutoRenew: ZIO[Any, AwsError, JavaBoolean] =
      AwsError.unwrapOptionField(
        "isLongTermPricingAutoRenew",
        isLongTermPricingAutoRenew
      )
    def getLongTermPricingStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("longTermPricingStatus", longTermPricingStatus)
    def getSnowballType
        : ZIO[Any, AwsError, zio.aws.snowball.model.SnowballType] =
      AwsError.unwrapOptionField("snowballType", snowballType)
    def getJobIds: ZIO[Any, AwsError, List[JobId]] =
      AwsError.unwrapOptionField("jobIds", jobIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.LongTermPricingListEntry
  ) extends zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly {
    override val longTermPricingId: Option[LongTermPricingId] = scala
      .Option(impl.longTermPricingId())
      .map(value => zio.aws.snowball.model.primitives.LongTermPricingId(value))
    override val longTermPricingEndDate: Option[Timestamp] = scala
      .Option(impl.longTermPricingEndDate())
      .map(value => zio.aws.snowball.model.primitives.Timestamp(value))
    override val longTermPricingStartDate: Option[Timestamp] = scala
      .Option(impl.longTermPricingStartDate())
      .map(value => zio.aws.snowball.model.primitives.Timestamp(value))
    override val longTermPricingType
        : Option[zio.aws.snowball.model.LongTermPricingType] = scala
      .Option(impl.longTermPricingType())
      .map(value => zio.aws.snowball.model.LongTermPricingType.wrap(value))
    override val currentActiveJob: Option[JobId] = scala
      .Option(impl.currentActiveJob())
      .map(value => zio.aws.snowball.model.primitives.JobId(value))
    override val replacementJob: Option[JobId] = scala
      .Option(impl.replacementJob())
      .map(value => zio.aws.snowball.model.primitives.JobId(value))
    override val isLongTermPricingAutoRenew: Option[JavaBoolean] = scala
      .Option(impl.isLongTermPricingAutoRenew())
      .map(value => zio.aws.snowball.model.primitives.JavaBoolean(value))
    override val longTermPricingStatus: Option[String] =
      scala.Option(impl.longTermPricingStatus()).map(value => value: String)
    override val snowballType: Option[zio.aws.snowball.model.SnowballType] =
      scala
        .Option(impl.snowballType())
        .map(value => zio.aws.snowball.model.SnowballType.wrap(value))
    override val jobIds: Option[List[JobId]] = scala
      .Option(impl.jobIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.primitives.JobId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.LongTermPricingListEntry
  ): zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly = new Wrapper(
    impl
  )
}
