package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait LongTermPricingType {
  def unwrap: software.amazon.awssdk.services.snowball.model.LongTermPricingType
}
object LongTermPricingType {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.LongTermPricingType
  ): zio.aws.snowball.model.LongTermPricingType = value match {
    case software.amazon.awssdk.services.snowball.model.LongTermPricingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.LongTermPricingType.ONE_YEAR =>
      val r = OneYear
      r
    case software.amazon.awssdk.services.snowball.model.LongTermPricingType.THREE_YEAR =>
      val r = ThreeYear
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.snowball.model.LongTermPricingType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.LongTermPricingType =
      software.amazon.awssdk.services.snowball.model.LongTermPricingType.UNKNOWN_TO_SDK_VERSION
  }
  case object OneYear extends zio.aws.snowball.model.LongTermPricingType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.LongTermPricingType =
      software.amazon.awssdk.services.snowball.model.LongTermPricingType.ONE_YEAR
  }
  case object ThreeYear extends zio.aws.snowball.model.LongTermPricingType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.LongTermPricingType =
      software.amazon.awssdk.services.snowball.model.LongTermPricingType.THREE_YEAR
  }
}
