package zio.aws.snowball.model
import java.lang.Integer
import zio.aws.snowball.model.primitives.StorageLimit
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NFSOnDeviceServiceConfiguration(
    storageLimit: Option[StorageLimit] = None,
    storageUnit: Option[zio.aws.snowball.model.StorageUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.NFSOnDeviceServiceConfiguration = {
    import NFSOnDeviceServiceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.NFSOnDeviceServiceConfiguration
      .builder()
      .optionallyWith(
        storageLimit.map(value => StorageLimit.unwrap(value): Integer)
      )(_.storageLimit)
      .optionallyWith(storageUnit.map(value => value.unwrap))(_.storageUnit)
      .build()
  }
  def asReadOnly
      : zio.aws.snowball.model.NFSOnDeviceServiceConfiguration.ReadOnly =
    zio.aws.snowball.model.NFSOnDeviceServiceConfiguration.wrap(buildAwsValue())
}
object NFSOnDeviceServiceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.NFSOnDeviceServiceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.NFSOnDeviceServiceConfiguration =
      zio.aws.snowball.model.NFSOnDeviceServiceConfiguration(
        storageLimit.map(value => value),
        storageUnit.map(value => value)
      )
    def storageLimit: Option[StorageLimit]
    def storageUnit: Option[zio.aws.snowball.model.StorageUnit]
    def getStorageLimit: ZIO[Any, AwsError, StorageLimit] =
      AwsError.unwrapOptionField("storageLimit", storageLimit)
    def getStorageUnit: ZIO[Any, AwsError, zio.aws.snowball.model.StorageUnit] =
      AwsError.unwrapOptionField("storageUnit", storageUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.NFSOnDeviceServiceConfiguration
  ) extends zio.aws.snowball.model.NFSOnDeviceServiceConfiguration.ReadOnly {
    override val storageLimit: Option[StorageLimit] = scala
      .Option(impl.storageLimit())
      .map(value => zio.aws.snowball.model.primitives.StorageLimit(value))
    override val storageUnit: Option[zio.aws.snowball.model.StorageUnit] = scala
      .Option(impl.storageUnit())
      .map(value => zio.aws.snowball.model.StorageUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.NFSOnDeviceServiceConfiguration
  ): zio.aws.snowball.model.NFSOnDeviceServiceConfiguration.ReadOnly =
    new Wrapper(impl)
}
