package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.SnsTopicARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Notification(
    snsTopicARN: Option[SnsTopicARN] = None,
    jobStatesToNotify: Option[Iterable[zio.aws.snowball.model.JobState]] = None,
    notifyAllJobStates: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.Notification = {
    import Notification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.Notification
      .builder()
      .optionallyWith(
        snsTopicARN.map(value => SnsTopicARN.unwrap(value): java.lang.String)
      )(_.snsTopicARN)
      .optionallyWith(
        jobStatesToNotify.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.jobStatesToNotifyWithStrings)
      .optionallyWith(
        notifyAllJobStates.map(value => value: java.lang.Boolean)
      )(_.notifyAllJobStates)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.Notification.ReadOnly =
    zio.aws.snowball.model.Notification.wrap(buildAwsValue())
}
object Notification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.Notification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.Notification =
      zio.aws.snowball.model.Notification(
        snsTopicARN.map(value => value),
        jobStatesToNotify.map(value => value),
        notifyAllJobStates.map(value => value)
      )
    def snsTopicARN: Option[SnsTopicARN]
    def jobStatesToNotify: Option[List[zio.aws.snowball.model.JobState]]
    def notifyAllJobStates: Option[Boolean]
    def getSnsTopicARN: ZIO[Any, AwsError, SnsTopicARN] =
      AwsError.unwrapOptionField("snsTopicARN", snsTopicARN)
    def getJobStatesToNotify
        : ZIO[Any, AwsError, List[zio.aws.snowball.model.JobState]] =
      AwsError.unwrapOptionField("jobStatesToNotify", jobStatesToNotify)
    def getNotifyAllJobStates: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("notifyAllJobStates", notifyAllJobStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.Notification
  ) extends zio.aws.snowball.model.Notification.ReadOnly {
    override val snsTopicARN: Option[SnsTopicARN] = scala
      .Option(impl.snsTopicARN())
      .map(value => zio.aws.snowball.model.primitives.SnsTopicARN(value))
    override val jobStatesToNotify
        : Option[List[zio.aws.snowball.model.JobState]] = scala
      .Option(impl.jobStatesToNotify())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.JobState.wrap(item)
        }.toList
      )
    override val notifyAllJobStates: Option[Boolean] =
      scala.Option(impl.notifyAllJobStates()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.Notification
  ): zio.aws.snowball.model.Notification.ReadOnly = new Wrapper(impl)
}
