package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OnDeviceServiceConfiguration(
    nfsOnDeviceService: Option[
      zio.aws.snowball.model.NFSOnDeviceServiceConfiguration
    ] = None,
    tgwOnDeviceService: Option[
      zio.aws.snowball.model.TGWOnDeviceServiceConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.OnDeviceServiceConfiguration = {
    import OnDeviceServiceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.OnDeviceServiceConfiguration
      .builder()
      .optionallyWith(nfsOnDeviceService.map(value => value.buildAwsValue()))(
        _.nfsOnDeviceService
      )
      .optionallyWith(tgwOnDeviceService.map(value => value.buildAwsValue()))(
        _.tgwOnDeviceService
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly =
    zio.aws.snowball.model.OnDeviceServiceConfiguration.wrap(buildAwsValue())
}
object OnDeviceServiceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.OnDeviceServiceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.OnDeviceServiceConfiguration =
      zio.aws.snowball.model.OnDeviceServiceConfiguration(
        nfsOnDeviceService.map(value => value.asEditable),
        tgwOnDeviceService.map(value => value.asEditable)
      )
    def nfsOnDeviceService: Option[
      zio.aws.snowball.model.NFSOnDeviceServiceConfiguration.ReadOnly
    ]
    def tgwOnDeviceService: Option[
      zio.aws.snowball.model.TGWOnDeviceServiceConfiguration.ReadOnly
    ]
    def getNfsOnDeviceService: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.NFSOnDeviceServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("nfsOnDeviceService", nfsOnDeviceService)
    def getTgwOnDeviceService: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.TGWOnDeviceServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("tgwOnDeviceService", tgwOnDeviceService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.OnDeviceServiceConfiguration
  ) extends zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly {
    override val nfsOnDeviceService: Option[
      zio.aws.snowball.model.NFSOnDeviceServiceConfiguration.ReadOnly
    ] = scala
      .Option(impl.nfsOnDeviceService())
      .map(value =>
        zio.aws.snowball.model.NFSOnDeviceServiceConfiguration.wrap(value)
      )
    override val tgwOnDeviceService: Option[
      zio.aws.snowball.model.TGWOnDeviceServiceConfiguration.ReadOnly
    ] = scala
      .Option(impl.tgwOnDeviceService())
      .map(value =>
        zio.aws.snowball.model.TGWOnDeviceServiceConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.OnDeviceServiceConfiguration
  ): zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
