package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait RemoteManagement {
  def unwrap: software.amazon.awssdk.services.snowball.model.RemoteManagement
}
object RemoteManagement {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.RemoteManagement
  ): zio.aws.snowball.model.RemoteManagement = value match {
    case software.amazon.awssdk.services.snowball.model.RemoteManagement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.RemoteManagement.INSTALLED_ONLY =>
      val r = INSTALLED_ONLY
      r
    case software.amazon.awssdk.services.snowball.model.RemoteManagement.INSTALLED_AUTOSTART =>
      val r = INSTALLED_AUTOSTART
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.snowball.model.RemoteManagement {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.RemoteManagement =
      software.amazon.awssdk.services.snowball.model.RemoteManagement.UNKNOWN_TO_SDK_VERSION
  }
  case object INSTALLED_ONLY extends zio.aws.snowball.model.RemoteManagement {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.RemoteManagement =
      software.amazon.awssdk.services.snowball.model.RemoteManagement.INSTALLED_ONLY
  }
  case object INSTALLED_AUTOSTART
      extends zio.aws.snowball.model.RemoteManagement {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.RemoteManagement =
      software.amazon.awssdk.services.snowball.model.RemoteManagement.INSTALLED_AUTOSTART
  }
}
