package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.ResourceARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3Resource(
    bucketArn: Option[ResourceARN] = None,
    keyRange: Option[zio.aws.snowball.model.KeyRange] = None,
    targetOnDeviceServices: Option[
      Iterable[zio.aws.snowball.model.TargetOnDeviceService]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.S3Resource = {
    import S3Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.S3Resource
      .builder()
      .optionallyWith(
        bucketArn.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.bucketArn)
      .optionallyWith(keyRange.map(value => value.buildAwsValue()))(_.keyRange)
      .optionallyWith(
        targetOnDeviceServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetOnDeviceServices)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.S3Resource.ReadOnly =
    zio.aws.snowball.model.S3Resource.wrap(buildAwsValue())
}
object S3Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.S3Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.S3Resource =
      zio.aws.snowball.model.S3Resource(
        bucketArn.map(value => value),
        keyRange.map(value => value.asEditable),
        targetOnDeviceServices.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bucketArn: Option[ResourceARN]
    def keyRange: Option[zio.aws.snowball.model.KeyRange.ReadOnly]
    def targetOnDeviceServices
        : Option[List[zio.aws.snowball.model.TargetOnDeviceService.ReadOnly]]
    def getBucketArn: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("bucketArn", bucketArn)
    def getKeyRange
        : ZIO[Any, AwsError, zio.aws.snowball.model.KeyRange.ReadOnly] =
      AwsError.unwrapOptionField("keyRange", keyRange)
    def getTargetOnDeviceServices: ZIO[Any, AwsError, List[
      zio.aws.snowball.model.TargetOnDeviceService.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetOnDeviceServices",
      targetOnDeviceServices
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.S3Resource
  ) extends zio.aws.snowball.model.S3Resource.ReadOnly {
    override val bucketArn: Option[ResourceARN] = scala
      .Option(impl.bucketArn())
      .map(value => zio.aws.snowball.model.primitives.ResourceARN(value))
    override val keyRange: Option[zio.aws.snowball.model.KeyRange.ReadOnly] =
      scala
        .Option(impl.keyRange())
        .map(value => zio.aws.snowball.model.KeyRange.wrap(value))
    override val targetOnDeviceServices
        : Option[List[zio.aws.snowball.model.TargetOnDeviceService.ReadOnly]] =
      scala
        .Option(impl.targetOnDeviceServices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.snowball.model.TargetOnDeviceService.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.S3Resource
  ): zio.aws.snowball.model.S3Resource.ReadOnly = new Wrapper(impl)
}
