package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Shipment(
    status: Option[String] = None,
    trackingNumber: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.Shipment = {
    import Shipment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.Shipment
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(trackingNumber.map(value => value: java.lang.String))(
        _.trackingNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.Shipment.ReadOnly =
    zio.aws.snowball.model.Shipment.wrap(buildAwsValue())
}
object Shipment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.snowball.model.Shipment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.Shipment = zio.aws.snowball.model
      .Shipment(status.map(value => value), trackingNumber.map(value => value))
    def status: Option[String]
    def trackingNumber: Option[String]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getTrackingNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trackingNumber", trackingNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.Shipment
  ) extends zio.aws.snowball.model.Shipment.ReadOnly {
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val trackingNumber: Option[String] =
      scala.Option(impl.trackingNumber()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.Shipment
  ): zio.aws.snowball.model.Shipment.ReadOnly = new Wrapper(impl)
}
