package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait ShipmentState {
  def unwrap: software.amazon.awssdk.services.snowball.model.ShipmentState
}
object ShipmentState {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.ShipmentState
  ): zio.aws.snowball.model.ShipmentState = value match {
    case software.amazon.awssdk.services.snowball.model.ShipmentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.ShipmentState.RECEIVED =>
      val r = RECEIVED
      r
    case software.amazon.awssdk.services.snowball.model.ShipmentState.RETURNED =>
      val r = RETURNED
      r
  }
  case object unknownToSdkVersion extends zio.aws.snowball.model.ShipmentState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShipmentState =
      software.amazon.awssdk.services.snowball.model.ShipmentState.UNKNOWN_TO_SDK_VERSION
  }
  case object RECEIVED extends zio.aws.snowball.model.ShipmentState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShipmentState =
      software.amazon.awssdk.services.snowball.model.ShipmentState.RECEIVED
  }
  case object RETURNED extends zio.aws.snowball.model.ShipmentState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShipmentState =
      software.amazon.awssdk.services.snowball.model.ShipmentState.RETURNED
  }
}
