package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ShippingDetails(
    shippingOption: Option[zio.aws.snowball.model.ShippingOption] = None,
    inboundShipment: Option[zio.aws.snowball.model.Shipment] = None,
    outboundShipment: Option[zio.aws.snowball.model.Shipment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.ShippingDetails = {
    import ShippingDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.ShippingDetails
      .builder()
      .optionallyWith(shippingOption.map(value => value.unwrap))(
        _.shippingOption
      )
      .optionallyWith(inboundShipment.map(value => value.buildAwsValue()))(
        _.inboundShipment
      )
      .optionallyWith(outboundShipment.map(value => value.buildAwsValue()))(
        _.outboundShipment
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.ShippingDetails.ReadOnly =
    zio.aws.snowball.model.ShippingDetails.wrap(buildAwsValue())
}
object ShippingDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.ShippingDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.ShippingDetails =
      zio.aws.snowball.model.ShippingDetails(
        shippingOption.map(value => value),
        inboundShipment.map(value => value.asEditable),
        outboundShipment.map(value => value.asEditable)
      )
    def shippingOption: Option[zio.aws.snowball.model.ShippingOption]
    def inboundShipment: Option[zio.aws.snowball.model.Shipment.ReadOnly]
    def outboundShipment: Option[zio.aws.snowball.model.Shipment.ReadOnly]
    def getShippingOption
        : ZIO[Any, AwsError, zio.aws.snowball.model.ShippingOption] =
      AwsError.unwrapOptionField("shippingOption", shippingOption)
    def getInboundShipment
        : ZIO[Any, AwsError, zio.aws.snowball.model.Shipment.ReadOnly] =
      AwsError.unwrapOptionField("inboundShipment", inboundShipment)
    def getOutboundShipment
        : ZIO[Any, AwsError, zio.aws.snowball.model.Shipment.ReadOnly] =
      AwsError.unwrapOptionField("outboundShipment", outboundShipment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.ShippingDetails
  ) extends zio.aws.snowball.model.ShippingDetails.ReadOnly {
    override val shippingOption: Option[zio.aws.snowball.model.ShippingOption] =
      scala
        .Option(impl.shippingOption())
        .map(value => zio.aws.snowball.model.ShippingOption.wrap(value))
    override val inboundShipment
        : Option[zio.aws.snowball.model.Shipment.ReadOnly] = scala
      .Option(impl.inboundShipment())
      .map(value => zio.aws.snowball.model.Shipment.wrap(value))
    override val outboundShipment
        : Option[zio.aws.snowball.model.Shipment.ReadOnly] = scala
      .Option(impl.outboundShipment())
      .map(value => zio.aws.snowball.model.Shipment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.ShippingDetails
  ): zio.aws.snowball.model.ShippingDetails.ReadOnly = new Wrapper(impl)
}
