package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait ShippingLabelStatus {
  def unwrap: software.amazon.awssdk.services.snowball.model.ShippingLabelStatus
}
object ShippingLabelStatus {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.ShippingLabelStatus
  ): zio.aws.snowball.model.ShippingLabelStatus = value match {
    case software.amazon.awssdk.services.snowball.model.ShippingLabelStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.ShippingLabelStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.snowball.model.ShippingLabelStatus.TIMED_OUT =>
      val r = TimedOut
      r
    case software.amazon.awssdk.services.snowball.model.ShippingLabelStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.snowball.model.ShippingLabelStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.snowball.model.ShippingLabelStatus {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShippingLabelStatus =
      software.amazon.awssdk.services.snowball.model.ShippingLabelStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.snowball.model.ShippingLabelStatus {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShippingLabelStatus =
      software.amazon.awssdk.services.snowball.model.ShippingLabelStatus.IN_PROGRESS
  }
  case object TimedOut extends zio.aws.snowball.model.ShippingLabelStatus {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShippingLabelStatus =
      software.amazon.awssdk.services.snowball.model.ShippingLabelStatus.TIMED_OUT
  }
  case object Succeeded extends zio.aws.snowball.model.ShippingLabelStatus {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShippingLabelStatus =
      software.amazon.awssdk.services.snowball.model.ShippingLabelStatus.SUCCEEDED
  }
  case object Failed extends zio.aws.snowball.model.ShippingLabelStatus {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShippingLabelStatus =
      software.amazon.awssdk.services.snowball.model.ShippingLabelStatus.FAILED
  }
}
