package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait ShippingOption {
  def unwrap: software.amazon.awssdk.services.snowball.model.ShippingOption
}
object ShippingOption {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.ShippingOption
  ): zio.aws.snowball.model.ShippingOption = value match {
    case software.amazon.awssdk.services.snowball.model.ShippingOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.ShippingOption.SECOND_DAY =>
      val r = SECOND_DAY
      r
    case software.amazon.awssdk.services.snowball.model.ShippingOption.NEXT_DAY =>
      val r = NEXT_DAY
      r
    case software.amazon.awssdk.services.snowball.model.ShippingOption.EXPRESS =>
      val r = EXPRESS
      r
    case software.amazon.awssdk.services.snowball.model.ShippingOption.STANDARD =>
      val r = STANDARD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.snowball.model.ShippingOption {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShippingOption =
      software.amazon.awssdk.services.snowball.model.ShippingOption.UNKNOWN_TO_SDK_VERSION
  }
  case object SECOND_DAY extends zio.aws.snowball.model.ShippingOption {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShippingOption =
      software.amazon.awssdk.services.snowball.model.ShippingOption.SECOND_DAY
  }
  case object NEXT_DAY extends zio.aws.snowball.model.ShippingOption {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShippingOption =
      software.amazon.awssdk.services.snowball.model.ShippingOption.NEXT_DAY
  }
  case object EXPRESS extends zio.aws.snowball.model.ShippingOption {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShippingOption =
      software.amazon.awssdk.services.snowball.model.ShippingOption.EXPRESS
  }
  case object STANDARD extends zio.aws.snowball.model.ShippingOption {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ShippingOption =
      software.amazon.awssdk.services.snowball.model.ShippingOption.STANDARD
  }
}
