package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait SnowballCapacity {
  def unwrap: software.amazon.awssdk.services.snowball.model.SnowballCapacity
}
object SnowballCapacity {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.SnowballCapacity
  ): zio.aws.snowball.model.SnowballCapacity = value match {
    case software.amazon.awssdk.services.snowball.model.SnowballCapacity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.SnowballCapacity.T50 =>
      val r = T50
      r
    case software.amazon.awssdk.services.snowball.model.SnowballCapacity.T80 =>
      val r = T80
      r
    case software.amazon.awssdk.services.snowball.model.SnowballCapacity.T100 =>
      val r = T100
      r
    case software.amazon.awssdk.services.snowball.model.SnowballCapacity.T42 =>
      val r = T42
      r
    case software.amazon.awssdk.services.snowball.model.SnowballCapacity.T98 =>
      val r = T98
      r
    case software.amazon.awssdk.services.snowball.model.SnowballCapacity.T8 =>
      val r = T8
      r
    case software.amazon.awssdk.services.snowball.model.SnowballCapacity.T14 =>
      val r = T14
      r
    case software.amazon.awssdk.services.snowball.model.SnowballCapacity.NO_PREFERENCE =>
      val r = NoPreference
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.snowball.model.SnowballCapacity {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballCapacity =
      software.amazon.awssdk.services.snowball.model.SnowballCapacity.UNKNOWN_TO_SDK_VERSION
  }
  case object T50 extends zio.aws.snowball.model.SnowballCapacity {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballCapacity =
      software.amazon.awssdk.services.snowball.model.SnowballCapacity.T50
  }
  case object T80 extends zio.aws.snowball.model.SnowballCapacity {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballCapacity =
      software.amazon.awssdk.services.snowball.model.SnowballCapacity.T80
  }
  case object T100 extends zio.aws.snowball.model.SnowballCapacity {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballCapacity =
      software.amazon.awssdk.services.snowball.model.SnowballCapacity.T100
  }
  case object T42 extends zio.aws.snowball.model.SnowballCapacity {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballCapacity =
      software.amazon.awssdk.services.snowball.model.SnowballCapacity.T42
  }
  case object T98 extends zio.aws.snowball.model.SnowballCapacity {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballCapacity =
      software.amazon.awssdk.services.snowball.model.SnowballCapacity.T98
  }
  case object T8 extends zio.aws.snowball.model.SnowballCapacity {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballCapacity =
      software.amazon.awssdk.services.snowball.model.SnowballCapacity.T8
  }
  case object T14 extends zio.aws.snowball.model.SnowballCapacity {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballCapacity =
      software.amazon.awssdk.services.snowball.model.SnowballCapacity.T14
  }
  case object NoPreference extends zio.aws.snowball.model.SnowballCapacity {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballCapacity =
      software.amazon.awssdk.services.snowball.model.SnowballCapacity.NO_PREFERENCE
  }
}
