package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait SnowballType {
  def unwrap: software.amazon.awssdk.services.snowball.model.SnowballType
}
object SnowballType {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.SnowballType
  ): zio.aws.snowball.model.SnowballType = value match {
    case software.amazon.awssdk.services.snowball.model.SnowballType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.SnowballType.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.snowball.model.SnowballType.EDGE =>
      val r = EDGE
      r
    case software.amazon.awssdk.services.snowball.model.SnowballType.EDGE_C =>
      val r = EDGE_C
      r
    case software.amazon.awssdk.services.snowball.model.SnowballType.EDGE_CG =>
      val r = EDGE_CG
      r
    case software.amazon.awssdk.services.snowball.model.SnowballType.EDGE_S =>
      val r = EDGE_S
      r
    case software.amazon.awssdk.services.snowball.model.SnowballType.SNC1_HDD =>
      val r = SNC1_HDD
      r
    case software.amazon.awssdk.services.snowball.model.SnowballType.SNC1_SSD =>
      val r = SNC1_SSD
      r
  }
  case object unknownToSdkVersion extends zio.aws.snowball.model.SnowballType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballType =
      software.amazon.awssdk.services.snowball.model.SnowballType.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.snowball.model.SnowballType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballType =
      software.amazon.awssdk.services.snowball.model.SnowballType.STANDARD
  }
  case object EDGE extends zio.aws.snowball.model.SnowballType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballType =
      software.amazon.awssdk.services.snowball.model.SnowballType.EDGE
  }
  case object EDGE_C extends zio.aws.snowball.model.SnowballType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballType =
      software.amazon.awssdk.services.snowball.model.SnowballType.EDGE_C
  }
  case object EDGE_CG extends zio.aws.snowball.model.SnowballType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballType =
      software.amazon.awssdk.services.snowball.model.SnowballType.EDGE_CG
  }
  case object EDGE_S extends zio.aws.snowball.model.SnowballType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballType =
      software.amazon.awssdk.services.snowball.model.SnowballType.EDGE_S
  }
  case object SNC1_HDD extends zio.aws.snowball.model.SnowballType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballType =
      software.amazon.awssdk.services.snowball.model.SnowballType.SNC1_HDD
  }
  case object SNC1_SSD extends zio.aws.snowball.model.SnowballType {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.SnowballType =
      software.amazon.awssdk.services.snowball.model.SnowballType.SNC1_SSD
  }
}
