package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SnowconeDeviceConfiguration(
    wirelessConnection: Option[zio.aws.snowball.model.WirelessConnection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.SnowconeDeviceConfiguration = {
    import SnowconeDeviceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.SnowconeDeviceConfiguration
      .builder()
      .optionallyWith(wirelessConnection.map(value => value.buildAwsValue()))(
        _.wirelessConnection
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.SnowconeDeviceConfiguration.ReadOnly =
    zio.aws.snowball.model.SnowconeDeviceConfiguration.wrap(buildAwsValue())
}
object SnowconeDeviceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.SnowconeDeviceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.SnowconeDeviceConfiguration =
      zio.aws.snowball.model.SnowconeDeviceConfiguration(
        wirelessConnection.map(value => value.asEditable)
      )
    def wirelessConnection
        : Option[zio.aws.snowball.model.WirelessConnection.ReadOnly]
    def getWirelessConnection: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.WirelessConnection.ReadOnly
    ] = AwsError.unwrapOptionField("wirelessConnection", wirelessConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.SnowconeDeviceConfiguration
  ) extends zio.aws.snowball.model.SnowconeDeviceConfiguration.ReadOnly {
    override val wirelessConnection
        : Option[zio.aws.snowball.model.WirelessConnection.ReadOnly] = scala
      .Option(impl.wirelessConnection())
      .map(value => zio.aws.snowball.model.WirelessConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.SnowconeDeviceConfiguration
  ): zio.aws.snowball.model.SnowconeDeviceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
