package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait StorageUnit {
  def unwrap: software.amazon.awssdk.services.snowball.model.StorageUnit
}
object StorageUnit {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.StorageUnit
  ): zio.aws.snowball.model.StorageUnit = value match {
    case software.amazon.awssdk.services.snowball.model.StorageUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.StorageUnit.TB =>
      val r = TB
      r
  }
  case object unknownToSdkVersion extends zio.aws.snowball.model.StorageUnit {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.StorageUnit =
      software.amazon.awssdk.services.snowball.model.StorageUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object TB extends zio.aws.snowball.model.StorageUnit {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.StorageUnit =
      software.amazon.awssdk.services.snowball.model.StorageUnit.TB
  }
}
