package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TargetOnDeviceService(
    serviceName: Option[zio.aws.snowball.model.DeviceServiceName] = None,
    transferOption: Option[zio.aws.snowball.model.TransferOption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.TargetOnDeviceService = {
    import TargetOnDeviceService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.TargetOnDeviceService
      .builder()
      .optionallyWith(serviceName.map(value => value.unwrap))(_.serviceName)
      .optionallyWith(transferOption.map(value => value.unwrap))(
        _.transferOption
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.TargetOnDeviceService.ReadOnly =
    zio.aws.snowball.model.TargetOnDeviceService.wrap(buildAwsValue())
}
object TargetOnDeviceService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.TargetOnDeviceService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.TargetOnDeviceService =
      zio.aws.snowball.model.TargetOnDeviceService(
        serviceName.map(value => value),
        transferOption.map(value => value)
      )
    def serviceName: Option[zio.aws.snowball.model.DeviceServiceName]
    def transferOption: Option[zio.aws.snowball.model.TransferOption]
    def getServiceName
        : ZIO[Any, AwsError, zio.aws.snowball.model.DeviceServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getTransferOption
        : ZIO[Any, AwsError, zio.aws.snowball.model.TransferOption] =
      AwsError.unwrapOptionField("transferOption", transferOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.TargetOnDeviceService
  ) extends zio.aws.snowball.model.TargetOnDeviceService.ReadOnly {
    override val serviceName: Option[zio.aws.snowball.model.DeviceServiceName] =
      scala
        .Option(impl.serviceName())
        .map(value => zio.aws.snowball.model.DeviceServiceName.wrap(value))
    override val transferOption: Option[zio.aws.snowball.model.TransferOption] =
      scala
        .Option(impl.transferOption())
        .map(value => zio.aws.snowball.model.TransferOption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.TargetOnDeviceService
  ): zio.aws.snowball.model.TargetOnDeviceService.ReadOnly = new Wrapper(impl)
}
