package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TaxDocuments(
    ind: Option[zio.aws.snowball.model.INDTaxDocuments] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.TaxDocuments = {
    import TaxDocuments.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.TaxDocuments
      .builder()
      .optionallyWith(ind.map(value => value.buildAwsValue()))(_.ind)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.TaxDocuments.ReadOnly =
    zio.aws.snowball.model.TaxDocuments.wrap(buildAwsValue())
}
object TaxDocuments {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.TaxDocuments
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.TaxDocuments =
      zio.aws.snowball.model.TaxDocuments(ind.map(value => value.asEditable))
    def ind: Option[zio.aws.snowball.model.INDTaxDocuments.ReadOnly]
    def getInd
        : ZIO[Any, AwsError, zio.aws.snowball.model.INDTaxDocuments.ReadOnly] =
      AwsError.unwrapOptionField("ind", ind)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.TaxDocuments
  ) extends zio.aws.snowball.model.TaxDocuments.ReadOnly {
    override val ind: Option[zio.aws.snowball.model.INDTaxDocuments.ReadOnly] =
      scala
        .Option(impl.ind())
        .map(value => zio.aws.snowball.model.INDTaxDocuments.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.TaxDocuments
  ): zio.aws.snowball.model.TaxDocuments.ReadOnly = new Wrapper(impl)
}
