package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait TransferOption {
  def unwrap: software.amazon.awssdk.services.snowball.model.TransferOption
}
object TransferOption {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.TransferOption
  ): zio.aws.snowball.model.TransferOption = value match {
    case software.amazon.awssdk.services.snowball.model.TransferOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.TransferOption.IMPORT =>
      val r = IMPORT
      r
    case software.amazon.awssdk.services.snowball.model.TransferOption.EXPORT =>
      val r = EXPORT
      r
    case software.amazon.awssdk.services.snowball.model.TransferOption.LOCAL_USE =>
      val r = LOCAL_USE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.snowball.model.TransferOption {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.TransferOption =
      software.amazon.awssdk.services.snowball.model.TransferOption.UNKNOWN_TO_SDK_VERSION
  }
  case object IMPORT extends zio.aws.snowball.model.TransferOption {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.TransferOption =
      software.amazon.awssdk.services.snowball.model.TransferOption.IMPORT
  }
  case object EXPORT extends zio.aws.snowball.model.TransferOption {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.TransferOption =
      software.amazon.awssdk.services.snowball.model.TransferOption.EXPORT
  }
  case object LOCAL_USE extends zio.aws.snowball.model.TransferOption {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.TransferOption =
      software.amazon.awssdk.services.snowball.model.TransferOption.LOCAL_USE
  }
}
