package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.{AddressId, RoleARN, JobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateJobRequest(
    jobId: JobId,
    roleARN: Option[RoleARN] = None,
    notification: Option[zio.aws.snowball.model.Notification] = None,
    resources: Option[zio.aws.snowball.model.JobResource] = None,
    onDeviceServiceConfiguration: Option[
      zio.aws.snowball.model.OnDeviceServiceConfiguration
    ] = None,
    addressId: Option[AddressId] = None,
    shippingOption: Option[zio.aws.snowball.model.ShippingOption] = None,
    description: Option[String] = None,
    snowballCapacityPreference: Option[
      zio.aws.snowball.model.SnowballCapacity
    ] = None,
    forwardingAddressId: Option[AddressId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.UpdateJobRequest = {
    import UpdateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.UpdateJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(notification.map(value => value.buildAwsValue()))(
        _.notification
      )
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .optionallyWith(
        onDeviceServiceConfiguration.map(value => value.buildAwsValue())
      )(_.onDeviceServiceConfiguration)
      .optionallyWith(
        addressId.map(value => AddressId.unwrap(value): java.lang.String)
      )(_.addressId)
      .optionallyWith(shippingOption.map(value => value.unwrap))(
        _.shippingOption
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(snowballCapacityPreference.map(value => value.unwrap))(
        _.snowballCapacityPreference
      )
      .optionallyWith(
        forwardingAddressId.map(value =>
          AddressId.unwrap(value): java.lang.String
        )
      )(_.forwardingAddressId)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.UpdateJobRequest.ReadOnly =
    zio.aws.snowball.model.UpdateJobRequest.wrap(buildAwsValue())
}
object UpdateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.UpdateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.UpdateJobRequest =
      zio.aws.snowball.model.UpdateJobRequest(
        jobId,
        roleARN.map(value => value),
        notification.map(value => value.asEditable),
        resources.map(value => value.asEditable),
        onDeviceServiceConfiguration.map(value => value.asEditable),
        addressId.map(value => value),
        shippingOption.map(value => value),
        description.map(value => value),
        snowballCapacityPreference.map(value => value),
        forwardingAddressId.map(value => value)
      )
    def jobId: JobId
    def roleARN: Option[RoleARN]
    def notification: Option[zio.aws.snowball.model.Notification.ReadOnly]
    def resources: Option[zio.aws.snowball.model.JobResource.ReadOnly]
    def onDeviceServiceConfiguration
        : Option[zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly]
    def addressId: Option[AddressId]
    def shippingOption: Option[zio.aws.snowball.model.ShippingOption]
    def description: Option[String]
    def snowballCapacityPreference
        : Option[zio.aws.snowball.model.SnowballCapacity]
    def forwardingAddressId: Option[AddressId]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getNotification
        : ZIO[Any, AwsError, zio.aws.snowball.model.Notification.ReadOnly] =
      AwsError.unwrapOptionField("notification", notification)
    def getResources
        : ZIO[Any, AwsError, zio.aws.snowball.model.JobResource.ReadOnly] =
      AwsError.unwrapOptionField("resources", resources)
    def getOnDeviceServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onDeviceServiceConfiguration",
      onDeviceServiceConfiguration
    )
    def getAddressId: ZIO[Any, AwsError, AddressId] =
      AwsError.unwrapOptionField("addressId", addressId)
    def getShippingOption
        : ZIO[Any, AwsError, zio.aws.snowball.model.ShippingOption] =
      AwsError.unwrapOptionField("shippingOption", shippingOption)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSnowballCapacityPreference
        : ZIO[Any, AwsError, zio.aws.snowball.model.SnowballCapacity] =
      AwsError.unwrapOptionField(
        "snowballCapacityPreference",
        snowballCapacityPreference
      )
    def getForwardingAddressId: ZIO[Any, AwsError, AddressId] =
      AwsError.unwrapOptionField("forwardingAddressId", forwardingAddressId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.UpdateJobRequest
  ) extends zio.aws.snowball.model.UpdateJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.snowball.model.primitives.JobId(impl.jobId())
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.snowball.model.primitives.RoleARN(value))
    override val notification
        : Option[zio.aws.snowball.model.Notification.ReadOnly] = scala
      .Option(impl.notification())
      .map(value => zio.aws.snowball.model.Notification.wrap(value))
    override val resources
        : Option[zio.aws.snowball.model.JobResource.ReadOnly] = scala
      .Option(impl.resources())
      .map(value => zio.aws.snowball.model.JobResource.wrap(value))
    override val onDeviceServiceConfiguration
        : Option[zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly] =
      scala
        .Option(impl.onDeviceServiceConfiguration())
        .map(value =>
          zio.aws.snowball.model.OnDeviceServiceConfiguration.wrap(value)
        )
    override val addressId: Option[AddressId] = scala
      .Option(impl.addressId())
      .map(value => zio.aws.snowball.model.primitives.AddressId(value))
    override val shippingOption: Option[zio.aws.snowball.model.ShippingOption] =
      scala
        .Option(impl.shippingOption())
        .map(value => zio.aws.snowball.model.ShippingOption.wrap(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val snowballCapacityPreference
        : Option[zio.aws.snowball.model.SnowballCapacity] = scala
      .Option(impl.snowballCapacityPreference())
      .map(value => zio.aws.snowball.model.SnowballCapacity.wrap(value))
    override val forwardingAddressId: Option[AddressId] = scala
      .Option(impl.forwardingAddressId())
      .map(value => zio.aws.snowball.model.primitives.AddressId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.UpdateJobRequest
  ): zio.aws.snowball.model.UpdateJobRequest.ReadOnly = new Wrapper(impl)
}
