package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateJobShipmentStateRequest(
    jobId: JobId,
    shipmentState: zio.aws.snowball.model.ShipmentState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateRequest = {
    import UpdateJobShipmentStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .shipmentState(shipmentState.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.snowball.model.UpdateJobShipmentStateRequest.ReadOnly =
    zio.aws.snowball.model.UpdateJobShipmentStateRequest.wrap(buildAwsValue())
}
object UpdateJobShipmentStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.UpdateJobShipmentStateRequest =
      zio.aws.snowball.model.UpdateJobShipmentStateRequest(jobId, shipmentState)
    def jobId: JobId
    def shipmentState: zio.aws.snowball.model.ShipmentState
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getShipmentState
        : ZIO[Any, Nothing, zio.aws.snowball.model.ShipmentState] =
      ZIO.succeed(shipmentState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateRequest
  ) extends zio.aws.snowball.model.UpdateJobShipmentStateRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.snowball.model.primitives.JobId(impl.jobId())
    override val shipmentState: zio.aws.snowball.model.ShipmentState =
      zio.aws.snowball.model.ShipmentState.wrap(impl.shipmentState())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateRequest
  ): zio.aws.snowball.model.UpdateJobShipmentStateRequest.ReadOnly =
    new Wrapper(impl)
}
