package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.{JavaBoolean, JobId, LongTermPricingId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateLongTermPricingRequest(
    longTermPricingId: LongTermPricingId,
    replacementJob: Option[JobId] = None,
    isLongTermPricingAutoRenew: Option[JavaBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingRequest = {
    import UpdateLongTermPricingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingRequest
      .builder()
      .longTermPricingId(
        LongTermPricingId.unwrap(longTermPricingId): java.lang.String
      )
      .optionallyWith(
        replacementJob.map(value => JobId.unwrap(value): java.lang.String)
      )(_.replacementJob)
      .optionallyWith(
        isLongTermPricingAutoRenew.map(value =>
          JavaBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.isLongTermPricingAutoRenew)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.UpdateLongTermPricingRequest.ReadOnly =
    zio.aws.snowball.model.UpdateLongTermPricingRequest.wrap(buildAwsValue())
}
object UpdateLongTermPricingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.UpdateLongTermPricingRequest =
      zio.aws.snowball.model.UpdateLongTermPricingRequest(
        longTermPricingId,
        replacementJob.map(value => value),
        isLongTermPricingAutoRenew.map(value => value)
      )
    def longTermPricingId: LongTermPricingId
    def replacementJob: Option[JobId]
    def isLongTermPricingAutoRenew: Option[JavaBoolean]
    def getLongTermPricingId: ZIO[Any, Nothing, LongTermPricingId] =
      ZIO.succeed(longTermPricingId)
    def getReplacementJob: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("replacementJob", replacementJob)
    def getIsLongTermPricingAutoRenew: ZIO[Any, AwsError, JavaBoolean] =
      AwsError.unwrapOptionField(
        "isLongTermPricingAutoRenew",
        isLongTermPricingAutoRenew
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingRequest
  ) extends zio.aws.snowball.model.UpdateLongTermPricingRequest.ReadOnly {
    override val longTermPricingId: LongTermPricingId =
      zio.aws.snowball.model.primitives
        .LongTermPricingId(impl.longTermPricingId())
    override val replacementJob: Option[JobId] = scala
      .Option(impl.replacementJob())
      .map(value => zio.aws.snowball.model.primitives.JobId(value))
    override val isLongTermPricingAutoRenew: Option[JavaBoolean] = scala
      .Option(impl.isLongTermPricingAutoRenew())
      .map(value => zio.aws.snowball.model.primitives.JavaBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingRequest
  ): zio.aws.snowball.model.UpdateLongTermPricingRequest.ReadOnly = new Wrapper(
    impl
  )
}
