package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class WirelessConnection(isWifiEnabled: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.WirelessConnection = {
    import WirelessConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.WirelessConnection
      .builder()
      .optionallyWith(isWifiEnabled.map(value => value: java.lang.Boolean))(
        _.isWifiEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.WirelessConnection.ReadOnly =
    zio.aws.snowball.model.WirelessConnection.wrap(buildAwsValue())
}
object WirelessConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.WirelessConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.WirelessConnection =
      zio.aws.snowball.model
        .WirelessConnection(isWifiEnabled.map(value => value))
    def isWifiEnabled: Option[Boolean]
    def getIsWifiEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isWifiEnabled", isWifiEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.WirelessConnection
  ) extends zio.aws.snowball.model.WirelessConnection.ReadOnly {
    override val isWifiEnabled: Option[Boolean] =
      scala.Option(impl.isWifiEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.WirelessConnection
  ): zio.aws.snowball.model.WirelessConnection.ReadOnly = new Wrapper(impl)
}
