package zio.aws.snowball
import zio.aws.snowball.model.primitives.JobId
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.snowball.model.primitives.ResourceARN.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AddressId extends Subtype[String]
    type AddressId = zio.aws.snowball.model.primitives.AddressId.Type
    object AmiId extends Subtype[String]
    type AmiId = zio.aws.snowball.model.primitives.AmiId.Type
    object ClusterId extends Subtype[String]
    type ClusterId = zio.aws.snowball.model.primitives.ClusterId.Type
    object GSTIN extends Subtype[String]
    type GSTIN = zio.aws.snowball.model.primitives.GSTIN.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.snowball.model.primitives.Integer.Type
    object JavaBoolean extends Subtype[Boolean]
    type JavaBoolean = zio.aws.snowball.model.primitives.JavaBoolean.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.snowball.model.primitives.JobId.Type
    object KmsKeyARN extends Subtype[String]
    type KmsKeyARN = zio.aws.snowball.model.primitives.KmsKeyARN.Type
    object ListLimit extends Subtype[Int]
    type ListLimit = zio.aws.snowball.model.primitives.ListLimit.Type
    object LongTermPricingId extends Subtype[String]
    type LongTermPricingId =
      zio.aws.snowball.model.primitives.LongTermPricingId.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN = zio.aws.snowball.model.primitives.ResourceARN.Type
    object RoleARN extends Subtype[String]
    type RoleARN = zio.aws.snowball.model.primitives.RoleARN.Type
    object SnsTopicARN extends Subtype[String]
    type SnsTopicARN = zio.aws.snowball.model.primitives.SnsTopicARN.Type
    object StorageLimit extends Subtype[Int]
    type StorageLimit = zio.aws.snowball.model.primitives.StorageLimit.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.snowball.model.primitives.Timestamp.Type
  }
  type AddressList = List[zio.aws.snowball.model.Address]
  type ClusterListEntryList = List[zio.aws.snowball.model.ClusterListEntry]
  type CompatibleImageList = List[zio.aws.snowball.model.CompatibleImage]
  type Ec2AmiResourceList = List[zio.aws.snowball.model.Ec2AmiResource]
  type EventTriggerDefinitionList =
    List[zio.aws.snowball.model.EventTriggerDefinition]
  type JobListEntryList = List[zio.aws.snowball.model.JobListEntry]
  type JobMetadataList = List[zio.aws.snowball.model.JobMetadata]
  type JobStateList = List[zio.aws.snowball.model.JobState]
  type LambdaResourceList = List[zio.aws.snowball.model.LambdaResource]
  type LongTermPricingAssociatedJobIdList = List[JobId]
  type LongTermPricingEntryList =
    List[zio.aws.snowball.model.LongTermPricingListEntry]
  type S3ResourceList = List[zio.aws.snowball.model.S3Resource]
  type TargetOnDeviceServiceList =
    List[zio.aws.snowball.model.TargetOnDeviceService]
}
