package zio.aws.ssm.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  IamRole,
  RegistrationsCount,
  RegistrationLimit,
  ActivationId,
  DefaultInstanceName,
  ExpirationDate,
  CreatedDate,
  ActivationDescription
}
import scala.jdk.CollectionConverters.*
final case class Activation(
    activationId: Option[ActivationId] = None,
    description: Option[ActivationDescription] = None,
    defaultInstanceName: Option[DefaultInstanceName] = None,
    iamRole: Option[IamRole] = None,
    registrationLimit: Option[RegistrationLimit] = None,
    registrationsCount: Option[RegistrationsCount] = None,
    expirationDate: Option[ExpirationDate] = None,
    expired: Option[Boolean] = None,
    createdDate: Option[CreatedDate] = None,
    tags: Option[Iterable[zio.aws.ssm.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Activation = {
    import Activation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Activation
      .builder()
      .optionallyWith(
        activationId.map(value => ActivationId.unwrap(value): java.lang.String)
      )(_.activationId)
      .optionallyWith(
        description.map(value =>
          ActivationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        defaultInstanceName.map(value =>
          DefaultInstanceName.unwrap(value): java.lang.String
        )
      )(_.defaultInstanceName)
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(
        registrationLimit.map(value => RegistrationLimit.unwrap(value): Integer)
      )(_.registrationLimit)
      .optionallyWith(
        registrationsCount.map(value =>
          RegistrationsCount.unwrap(value): Integer
        )
      )(_.registrationsCount)
      .optionallyWith(
        expirationDate.map(value => ExpirationDate.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(expired.map(value => value: java.lang.Boolean))(_.expired)
      .optionallyWith(
        createdDate.map(value => CreatedDate.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Activation.ReadOnly =
    zio.aws.ssm.model.Activation.wrap(buildAwsValue())
}
object Activation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Activation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Activation = zio.aws.ssm.model.Activation(
      activationId.map(value => value),
      description.map(value => value),
      defaultInstanceName.map(value => value),
      iamRole.map(value => value),
      registrationLimit.map(value => value),
      registrationsCount.map(value => value),
      expirationDate.map(value => value),
      expired.map(value => value),
      createdDate.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def activationId: Option[ActivationId]
    def description: Option[ActivationDescription]
    def defaultInstanceName: Option[DefaultInstanceName]
    def iamRole: Option[IamRole]
    def registrationLimit: Option[RegistrationLimit]
    def registrationsCount: Option[RegistrationsCount]
    def expirationDate: Option[ExpirationDate]
    def expired: Option[Boolean]
    def createdDate: Option[CreatedDate]
    def tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def getActivationId: ZIO[Any, AwsError, ActivationId] =
      AwsError.unwrapOptionField("activationId", activationId)
    def getDescription: ZIO[Any, AwsError, ActivationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultInstanceName: ZIO[Any, AwsError, DefaultInstanceName] =
      AwsError.unwrapOptionField("defaultInstanceName", defaultInstanceName)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getRegistrationLimit: ZIO[Any, AwsError, RegistrationLimit] =
      AwsError.unwrapOptionField("registrationLimit", registrationLimit)
    def getRegistrationsCount: ZIO[Any, AwsError, RegistrationsCount] =
      AwsError.unwrapOptionField("registrationsCount", registrationsCount)
    def getExpirationDate: ZIO[Any, AwsError, ExpirationDate] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getExpired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("expired", expired)
    def getCreatedDate: ZIO[Any, AwsError, CreatedDate] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Activation
  ) extends zio.aws.ssm.model.Activation.ReadOnly {
    override val activationId: Option[ActivationId] = scala
      .Option(impl.activationId())
      .map(value => zio.aws.ssm.model.primitives.ActivationId(value))
    override val description: Option[ActivationDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.ssm.model.primitives.ActivationDescription(value))
    override val defaultInstanceName: Option[DefaultInstanceName] = scala
      .Option(impl.defaultInstanceName())
      .map(value => zio.aws.ssm.model.primitives.DefaultInstanceName(value))
    override val iamRole: Option[IamRole] = scala
      .Option(impl.iamRole())
      .map(value => zio.aws.ssm.model.primitives.IamRole(value))
    override val registrationLimit: Option[RegistrationLimit] = scala
      .Option(impl.registrationLimit())
      .map(value => zio.aws.ssm.model.primitives.RegistrationLimit(value))
    override val registrationsCount: Option[RegistrationsCount] = scala
      .Option(impl.registrationsCount())
      .map(value => zio.aws.ssm.model.primitives.RegistrationsCount(value))
    override val expirationDate: Option[ExpirationDate] = scala
      .Option(impl.expirationDate())
      .map(value => zio.aws.ssm.model.primitives.ExpirationDate(value))
    override val expired: Option[Boolean] =
      scala.Option(impl.expired()).map(value => value: Boolean)
    override val createdDate: Option[CreatedDate] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.CreatedDate(value))
    override val tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Activation
  ): zio.aws.ssm.model.Activation.ReadOnly = new Wrapper(impl)
}
