package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AttachmentUrl,
  AttachmentHash,
  ContentLength,
  AttachmentName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AttachmentContent(
    name: Option[AttachmentName] = None,
    size: Option[ContentLength] = None,
    hash: Option[AttachmentHash] = None,
    hashType: Option[zio.aws.ssm.model.AttachmentHashType] = None,
    url: Option[AttachmentUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AttachmentContent = {
    import AttachmentContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AttachmentContent
      .builder()
      .optionallyWith(
        name.map(value => AttachmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        size.map(value => ContentLength.unwrap(value): java.lang.Long)
      )(_.size)
      .optionallyWith(
        hash.map(value => AttachmentHash.unwrap(value): java.lang.String)
      )(_.hash)
      .optionallyWith(hashType.map(value => value.unwrap))(_.hashType)
      .optionallyWith(
        url.map(value => AttachmentUrl.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AttachmentContent.ReadOnly =
    zio.aws.ssm.model.AttachmentContent.wrap(buildAwsValue())
}
object AttachmentContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AttachmentContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AttachmentContent =
      zio.aws.ssm.model.AttachmentContent(
        name.map(value => value),
        size.map(value => value),
        hash.map(value => value),
        hashType.map(value => value),
        url.map(value => value)
      )
    def name: Option[AttachmentName]
    def size: Option[ContentLength]
    def hash: Option[AttachmentHash]
    def hashType: Option[zio.aws.ssm.model.AttachmentHashType]
    def url: Option[AttachmentUrl]
    def getName: ZIO[Any, AwsError, AttachmentName] =
      AwsError.unwrapOptionField("name", name)
    def getSize: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("size", size)
    def getHash: ZIO[Any, AwsError, AttachmentHash] =
      AwsError.unwrapOptionField("hash", hash)
    def getHashType: ZIO[Any, AwsError, zio.aws.ssm.model.AttachmentHashType] =
      AwsError.unwrapOptionField("hashType", hashType)
    def getUrl: ZIO[Any, AwsError, AttachmentUrl] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AttachmentContent
  ) extends zio.aws.ssm.model.AttachmentContent.ReadOnly {
    override val name: Option[AttachmentName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.AttachmentName(value))
    override val size: Option[ContentLength] = scala
      .Option(impl.size())
      .map(value => zio.aws.ssm.model.primitives.ContentLength(value))
    override val hash: Option[AttachmentHash] = scala
      .Option(impl.hash())
      .map(value => zio.aws.ssm.model.primitives.AttachmentHash(value))
    override val hashType: Option[zio.aws.ssm.model.AttachmentHashType] = scala
      .Option(impl.hashType())
      .map(value => zio.aws.ssm.model.AttachmentHashType.wrap(value))
    override val url: Option[AttachmentUrl] = scala
      .Option(impl.url())
      .map(value => zio.aws.ssm.model.primitives.AttachmentUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AttachmentContent
  ): zio.aws.ssm.model.AttachmentContent.ReadOnly = new Wrapper(impl)
}
