package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait AutomationExecutionFilterKey {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey
}
object AutomationExecutionFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey
  ): zio.aws.ssm.model.AutomationExecutionFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.DOCUMENT_NAME_PREFIX =>
      val r = DocumentNamePrefix
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.EXECUTION_STATUS =>
      val r = ExecutionStatus
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.EXECUTION_ID =>
      val r = ExecutionId
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.PARENT_EXECUTION_ID =>
      val r = ParentExecutionId
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.CURRENT_ACTION =>
      val r = CurrentAction
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.START_TIME_BEFORE =>
      val r = StartTimeBefore
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.START_TIME_AFTER =>
      val r = StartTimeAfter
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.AUTOMATION_TYPE =>
      val r = AutomationType
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.TAG_KEY =>
      val r = TagKey
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.TARGET_RESOURCE_GROUP =>
      val r = TargetResourceGroup
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.AUTOMATION_SUBTYPE =>
      val r = AutomationSubtype
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.OPS_ITEM_ID =>
      val r = OpsItemId
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object DocumentNamePrefix
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.DOCUMENT_NAME_PREFIX
  }
  case object ExecutionStatus
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.EXECUTION_STATUS
  }
  case object ExecutionId
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.EXECUTION_ID
  }
  case object ParentExecutionId
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.PARENT_EXECUTION_ID
  }
  case object CurrentAction
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.CURRENT_ACTION
  }
  case object StartTimeBefore
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.START_TIME_BEFORE
  }
  case object StartTimeAfter
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.START_TIME_AFTER
  }
  case object AutomationType
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.AUTOMATION_TYPE
  }
  case object TagKey extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.TAG_KEY
  }
  case object TargetResourceGroup
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.TARGET_RESOURCE_GROUP
  }
  case object AutomationSubtype
      extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.AUTOMATION_SUBTYPE
  }
  case object OpsItemId extends zio.aws.ssm.model.AutomationExecutionFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionFilterKey.OPS_ITEM_ID
  }
}
