package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{InstanceId, CommandId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CancelCommandRequest(
    commandId: CommandId,
    instanceIds: Option[Iterable[InstanceId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CancelCommandRequest = {
    import CancelCommandRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CancelCommandRequest
      .builder()
      .commandId(CommandId.unwrap(commandId): java.lang.String)
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CancelCommandRequest.ReadOnly =
    zio.aws.ssm.model.CancelCommandRequest.wrap(buildAwsValue())
}
object CancelCommandRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CancelCommandRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CancelCommandRequest = zio.aws.ssm.model
      .CancelCommandRequest(commandId, instanceIds.map(value => value))
    def commandId: CommandId
    def instanceIds: Option[List[InstanceId]]
    def getCommandId: ZIO[Any, Nothing, CommandId] = ZIO.succeed(commandId)
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CancelCommandRequest
  ) extends zio.aws.ssm.model.CancelCommandRequest.ReadOnly {
    override val commandId: CommandId =
      zio.aws.ssm.model.primitives.CommandId(impl.commandId())
    override val instanceIds: Option[List[InstanceId]] = scala
      .Option(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.InstanceId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CancelCommandRequest
  ): zio.aws.ssm.model.CancelCommandRequest.ReadOnly = new Wrapper(impl)
}
