package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait CommandFilterKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.CommandFilterKey
}
object CommandFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.CommandFilterKey
  ): zio.aws.ssm.model.CommandFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.CommandFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.CommandFilterKey.INVOKED_AFTER =>
      val r = InvokedAfter
      r
    case software.amazon.awssdk.services.ssm.model.CommandFilterKey.INVOKED_BEFORE =>
      val r = InvokedBefore
      r
    case software.amazon.awssdk.services.ssm.model.CommandFilterKey.STATUS =>
      val r = Status
      r
    case software.amazon.awssdk.services.ssm.model.CommandFilterKey.EXECUTION_STAGE =>
      val r = ExecutionStage
      r
    case software.amazon.awssdk.services.ssm.model.CommandFilterKey.DOCUMENT_NAME =>
      val r = DocumentName
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.CommandFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandFilterKey =
      software.amazon.awssdk.services.ssm.model.CommandFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object InvokedAfter extends zio.aws.ssm.model.CommandFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandFilterKey =
      software.amazon.awssdk.services.ssm.model.CommandFilterKey.INVOKED_AFTER
  }
  case object InvokedBefore extends zio.aws.ssm.model.CommandFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandFilterKey =
      software.amazon.awssdk.services.ssm.model.CommandFilterKey.INVOKED_BEFORE
  }
  case object Status extends zio.aws.ssm.model.CommandFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandFilterKey =
      software.amazon.awssdk.services.ssm.model.CommandFilterKey.STATUS
  }
  case object ExecutionStage extends zio.aws.ssm.model.CommandFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandFilterKey =
      software.amazon.awssdk.services.ssm.model.CommandFilterKey.EXECUTION_STAGE
  }
  case object DocumentName extends zio.aws.ssm.model.CommandFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandFilterKey =
      software.amazon.awssdk.services.ssm.model.CommandFilterKey.DOCUMENT_NAME
  }
}
