package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AttributeValue,
  AttributeName,
  ComplianceItemTitle,
  ComplianceItemId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ComplianceItemEntry(
    id: Option[ComplianceItemId] = None,
    title: Option[ComplianceItemTitle] = None,
    severity: zio.aws.ssm.model.ComplianceSeverity,
    status: zio.aws.ssm.model.ComplianceStatus,
    details: Option[Map[AttributeName, AttributeValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ComplianceItemEntry = {
    import ComplianceItemEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ComplianceItemEntry
      .builder()
      .optionallyWith(
        id.map(value => ComplianceItemId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        title.map(value => ComplianceItemTitle.unwrap(value): java.lang.String)
      )(_.title)
      .severity(severity.unwrap)
      .status(status.unwrap)
      .optionallyWith(
        details.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.details)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ComplianceItemEntry.ReadOnly =
    zio.aws.ssm.model.ComplianceItemEntry.wrap(buildAwsValue())
}
object ComplianceItemEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ComplianceItemEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ComplianceItemEntry =
      zio.aws.ssm.model.ComplianceItemEntry(
        id.map(value => value),
        title.map(value => value),
        severity,
        status,
        details.map(value => value)
      )
    def id: Option[ComplianceItemId]
    def title: Option[ComplianceItemTitle]
    def severity: zio.aws.ssm.model.ComplianceSeverity
    def status: zio.aws.ssm.model.ComplianceStatus
    def details: Option[Map[AttributeName, AttributeValue]]
    def getId: ZIO[Any, AwsError, ComplianceItemId] =
      AwsError.unwrapOptionField("id", id)
    def getTitle: ZIO[Any, AwsError, ComplianceItemTitle] =
      AwsError.unwrapOptionField("title", title)
    def getSeverity: ZIO[Any, Nothing, zio.aws.ssm.model.ComplianceSeverity] =
      ZIO.succeed(severity)
    def getStatus: ZIO[Any, Nothing, zio.aws.ssm.model.ComplianceStatus] =
      ZIO.succeed(status)
    def getDetails: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ComplianceItemEntry
  ) extends zio.aws.ssm.model.ComplianceItemEntry.ReadOnly {
    override val id: Option[ComplianceItemId] = scala
      .Option(impl.id())
      .map(value => zio.aws.ssm.model.primitives.ComplianceItemId(value))
    override val title: Option[ComplianceItemTitle] = scala
      .Option(impl.title())
      .map(value => zio.aws.ssm.model.primitives.ComplianceItemTitle(value))
    override val severity: zio.aws.ssm.model.ComplianceSeverity =
      zio.aws.ssm.model.ComplianceSeverity.wrap(impl.severity())
    override val status: zio.aws.ssm.model.ComplianceStatus =
      zio.aws.ssm.model.ComplianceStatus.wrap(impl.status())
    override val details: Option[Map[AttributeName, AttributeValue]] = scala
      .Option(impl.details())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.AttributeName(
              key
            ) -> zio.aws.ssm.model.primitives.AttributeValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ComplianceItemEntry
  ): zio.aws.ssm.model.ComplianceItemEntry.ReadOnly = new Wrapper(impl)
}
