package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ComplianceFilterValue,
  ComplianceStringFilterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ComplianceStringFilter(
    key: Option[ComplianceStringFilterKey] = None,
    values: Option[Iterable[ComplianceFilterValue]] = None,
    `type`: Option[zio.aws.ssm.model.ComplianceQueryOperatorType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ComplianceStringFilter = {
    import ComplianceStringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ComplianceStringFilter
      .builder()
      .optionallyWith(
        key.map(value =>
          ComplianceStringFilterKey.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            ComplianceFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ComplianceStringFilter.ReadOnly =
    zio.aws.ssm.model.ComplianceStringFilter.wrap(buildAwsValue())
}
object ComplianceStringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ComplianceStringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ComplianceStringFilter =
      zio.aws.ssm.model.ComplianceStringFilter(
        key.map(value => value),
        values.map(value => value),
        `type`.map(value => value)
      )
    def key: Option[ComplianceStringFilterKey]
    def values: Option[List[ComplianceFilterValue]]
    def `type`: Option[zio.aws.ssm.model.ComplianceQueryOperatorType]
    def getKey: ZIO[Any, AwsError, ComplianceStringFilterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[ComplianceFilterValue]] =
      AwsError.unwrapOptionField("values", values)
    def getType
        : ZIO[Any, AwsError, zio.aws.ssm.model.ComplianceQueryOperatorType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ComplianceStringFilter
  ) extends zio.aws.ssm.model.ComplianceStringFilter.ReadOnly {
    override val key: Option[ComplianceStringFilterKey] = scala
      .Option(impl.key())
      .map(value =>
        zio.aws.ssm.model.primitives.ComplianceStringFilterKey(value)
      )
    override val values: Option[List[ComplianceFilterValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.ComplianceFilterValue(item)
        }.toList
      )
    override val `type`: Option[zio.aws.ssm.model.ComplianceQueryOperatorType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.ssm.model.ComplianceQueryOperatorType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ComplianceStringFilter
  ): zio.aws.ssm.model.ComplianceStringFilter.ReadOnly = new Wrapper(impl)
}
