package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ComplianceTypeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ComplianceSummaryItem(
    complianceType: Option[ComplianceTypeName] = None,
    compliantSummary: Option[zio.aws.ssm.model.CompliantSummary] = None,
    nonCompliantSummary: Option[zio.aws.ssm.model.NonCompliantSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ComplianceSummaryItem = {
    import ComplianceSummaryItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ComplianceSummaryItem
      .builder()
      .optionallyWith(
        complianceType.map(value =>
          ComplianceTypeName.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .optionallyWith(compliantSummary.map(value => value.buildAwsValue()))(
        _.compliantSummary
      )
      .optionallyWith(nonCompliantSummary.map(value => value.buildAwsValue()))(
        _.nonCompliantSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly =
    zio.aws.ssm.model.ComplianceSummaryItem.wrap(buildAwsValue())
}
object ComplianceSummaryItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ComplianceSummaryItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ComplianceSummaryItem =
      zio.aws.ssm.model.ComplianceSummaryItem(
        complianceType.map(value => value),
        compliantSummary.map(value => value.asEditable),
        nonCompliantSummary.map(value => value.asEditable)
      )
    def complianceType: Option[ComplianceTypeName]
    def compliantSummary: Option[zio.aws.ssm.model.CompliantSummary.ReadOnly]
    def nonCompliantSummary
        : Option[zio.aws.ssm.model.NonCompliantSummary.ReadOnly]
    def getComplianceType: ZIO[Any, AwsError, ComplianceTypeName] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getCompliantSummary
        : ZIO[Any, AwsError, zio.aws.ssm.model.CompliantSummary.ReadOnly] =
      AwsError.unwrapOptionField("compliantSummary", compliantSummary)
    def getNonCompliantSummary
        : ZIO[Any, AwsError, zio.aws.ssm.model.NonCompliantSummary.ReadOnly] =
      AwsError.unwrapOptionField("nonCompliantSummary", nonCompliantSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ComplianceSummaryItem
  ) extends zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly {
    override val complianceType: Option[ComplianceTypeName] = scala
      .Option(impl.complianceType())
      .map(value => zio.aws.ssm.model.primitives.ComplianceTypeName(value))
    override val compliantSummary
        : Option[zio.aws.ssm.model.CompliantSummary.ReadOnly] = scala
      .Option(impl.compliantSummary())
      .map(value => zio.aws.ssm.model.CompliantSummary.wrap(value))
    override val nonCompliantSummary
        : Option[zio.aws.ssm.model.NonCompliantSummary.ReadOnly] = scala
      .Option(impl.nonCompliantSummary())
      .map(value => zio.aws.ssm.model.NonCompliantSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ComplianceSummaryItem
  ): zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly = new Wrapper(impl)
}
