package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait ComplianceUploadType {
  def unwrap: software.amazon.awssdk.services.ssm.model.ComplianceUploadType
}
object ComplianceUploadType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ComplianceUploadType
  ): zio.aws.ssm.model.ComplianceUploadType = value match {
    case software.amazon.awssdk.services.ssm.model.ComplianceUploadType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceUploadType.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceUploadType.PARTIAL =>
      val r = PARTIAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.ComplianceUploadType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceUploadType =
      software.amazon.awssdk.services.ssm.model.ComplianceUploadType.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETE extends zio.aws.ssm.model.ComplianceUploadType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceUploadType =
      software.amazon.awssdk.services.ssm.model.ComplianceUploadType.COMPLETE
  }
  case object PARTIAL extends zio.aws.ssm.model.ComplianceUploadType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceUploadType =
      software.amazon.awssdk.services.ssm.model.ComplianceUploadType.PARTIAL
  }
}
