package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{UUID, DryRun, InventoryItemTypeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteInventoryRequest(
    typeName: InventoryItemTypeName,
    schemaDeleteOption: Option[zio.aws.ssm.model.InventorySchemaDeleteOption] =
      None,
    dryRun: Option[DryRun] = None,
    clientToken: Option[UUID] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteInventoryRequest = {
    import DeleteInventoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteInventoryRequest
      .builder()
      .typeName(InventoryItemTypeName.unwrap(typeName): java.lang.String)
      .optionallyWith(schemaDeleteOption.map(value => value.unwrap))(
        _.schemaDeleteOption
      )
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .optionallyWith(
        clientToken.map(value => UUID.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteInventoryRequest.ReadOnly =
    zio.aws.ssm.model.DeleteInventoryRequest.wrap(buildAwsValue())
}
object DeleteInventoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteInventoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteInventoryRequest =
      zio.aws.ssm.model.DeleteInventoryRequest(
        typeName,
        schemaDeleteOption.map(value => value),
        dryRun.map(value => value),
        clientToken.map(value => value)
      )
    def typeName: InventoryItemTypeName
    def schemaDeleteOption
        : Option[zio.aws.ssm.model.InventorySchemaDeleteOption]
    def dryRun: Option[DryRun]
    def clientToken: Option[UUID]
    def getTypeName: ZIO[Any, Nothing, InventoryItemTypeName] =
      ZIO.succeed(typeName)
    def getSchemaDeleteOption
        : ZIO[Any, AwsError, zio.aws.ssm.model.InventorySchemaDeleteOption] =
      AwsError.unwrapOptionField("schemaDeleteOption", schemaDeleteOption)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getClientToken: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteInventoryRequest
  ) extends zio.aws.ssm.model.DeleteInventoryRequest.ReadOnly {
    override val typeName: InventoryItemTypeName =
      zio.aws.ssm.model.primitives.InventoryItemTypeName(impl.typeName())
    override val schemaDeleteOption
        : Option[zio.aws.ssm.model.InventorySchemaDeleteOption] = scala
      .Option(impl.schemaDeleteOption())
      .map(value => zio.aws.ssm.model.InventorySchemaDeleteOption.wrap(value))
    override val dryRun: Option[DryRun] = scala
      .Option(impl.dryRun())
      .map(value => zio.aws.ssm.model.primitives.DryRun(value))
    override val clientToken: Option[UUID] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.ssm.model.primitives.UUID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteInventoryRequest
  ): zio.aws.ssm.model.DeleteInventoryRequest.ReadOnly = new Wrapper(impl)
}
