package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{PatchGroup, BaselineId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeregisterPatchBaselineForPatchGroupResponse(
    baselineId: Option[BaselineId] = None,
    patchGroup: Option[PatchGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse = {
    import DeregisterPatchBaselineForPatchGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse
      .builder()
      .optionallyWith(
        baselineId.map(value => BaselineId.unwrap(value): java.lang.String)
      )(_.baselineId)
      .optionallyWith(
        patchGroup.map(value => PatchGroup.unwrap(value): java.lang.String)
      )(_.patchGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse.ReadOnly =
    zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse
      .wrap(buildAwsValue())
}
object DeregisterPatchBaselineForPatchGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse =
      zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse(
        baselineId.map(value => value),
        patchGroup.map(value => value)
      )
    def baselineId: Option[BaselineId]
    def patchGroup: Option[PatchGroup]
    def getBaselineId: ZIO[Any, AwsError, BaselineId] =
      AwsError.unwrapOptionField("baselineId", baselineId)
    def getPatchGroup: ZIO[Any, AwsError, PatchGroup] =
      AwsError.unwrapOptionField("patchGroup", patchGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse
  ) extends zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse.ReadOnly {
    override val baselineId: Option[BaselineId] = scala
      .Option(impl.baselineId())
      .map(value => zio.aws.ssm.model.primitives.BaselineId(value))
    override val patchGroup: Option[PatchGroup] = scala
      .Option(impl.patchGroup())
      .map(value => zio.aws.ssm.model.primitives.PatchGroup(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse
  ): zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse.ReadOnly =
    new Wrapper(impl)
}
