package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeMaintenanceWindowScheduleResponse(
    scheduledWindowExecutions: Option[
      Iterable[zio.aws.ssm.model.ScheduledWindowExecution]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse = {
    import DescribeMaintenanceWindowScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse
      .builder()
      .optionallyWith(
        scheduledWindowExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledWindowExecutions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse =
      zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse(
        scheduledWindowExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scheduledWindowExecutions
        : Option[List[zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly]]
    def nextToken: Option[NextToken]
    def getScheduledWindowExecutions: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "scheduledWindowExecutions",
      scheduledWindowExecutions
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse.ReadOnly {
    override val scheduledWindowExecutions
        : Option[List[zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly]] =
      scala
        .Option(impl.scheduledWindowExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ScheduledWindowExecution.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse
  ): zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
