package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribePatchGroupsResponse(
    mappings: Option[
      Iterable[zio.aws.ssm.model.PatchGroupPatchBaselineMapping]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse = {
    import DescribePatchGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse
      .builder()
      .optionallyWith(
        mappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mappings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchGroupsResponse.ReadOnly =
    zio.aws.ssm.model.DescribePatchGroupsResponse.wrap(buildAwsValue())
}
object DescribePatchGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchGroupsResponse =
      zio.aws.ssm.model.DescribePatchGroupsResponse(
        mappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def mappings: Option[
      List[zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getMappings: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("mappings", mappings)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse
  ) extends zio.aws.ssm.model.DescribePatchGroupsResponse.ReadOnly {
    override val mappings: Option[
      List[zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly]
    ] = scala
      .Option(impl.mappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.PatchGroupPatchBaselineMapping.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse
  ): zio.aws.ssm.model.DescribePatchGroupsResponse.ReadOnly = new Wrapper(impl)
}
