package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribePatchPropertiesRequest(
    operatingSystem: zio.aws.ssm.model.OperatingSystem,
    property: zio.aws.ssm.model.PatchProperty,
    patchSet: Option[zio.aws.ssm.model.PatchSet] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest = {
    import DescribePatchPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest
      .builder()
      .operatingSystem(operatingSystem.unwrap)
      .property(property.unwrap)
      .optionallyWith(patchSet.map(value => value.unwrap))(_.patchSet)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchPropertiesRequest.ReadOnly =
    zio.aws.ssm.model.DescribePatchPropertiesRequest.wrap(buildAwsValue())
}
object DescribePatchPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchPropertiesRequest =
      zio.aws.ssm.model.DescribePatchPropertiesRequest(
        operatingSystem,
        property,
        patchSet.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def operatingSystem: zio.aws.ssm.model.OperatingSystem
    def property: zio.aws.ssm.model.PatchProperty
    def patchSet: Option[zio.aws.ssm.model.PatchSet]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getOperatingSystem
        : ZIO[Any, Nothing, zio.aws.ssm.model.OperatingSystem] =
      ZIO.succeed(operatingSystem)
    def getProperty: ZIO[Any, Nothing, zio.aws.ssm.model.PatchProperty] =
      ZIO.succeed(property)
    def getPatchSet: ZIO[Any, AwsError, zio.aws.ssm.model.PatchSet] =
      AwsError.unwrapOptionField("patchSet", patchSet)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest
  ) extends zio.aws.ssm.model.DescribePatchPropertiesRequest.ReadOnly {
    override val operatingSystem: zio.aws.ssm.model.OperatingSystem =
      zio.aws.ssm.model.OperatingSystem.wrap(impl.operatingSystem())
    override val property: zio.aws.ssm.model.PatchProperty =
      zio.aws.ssm.model.PatchProperty.wrap(impl.property())
    override val patchSet: Option[zio.aws.ssm.model.PatchSet] = scala
      .Option(impl.patchSet())
      .map(value => zio.aws.ssm.model.PatchSet.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest
  ): zio.aws.ssm.model.DescribePatchPropertiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
