package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.DocumentFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DocumentFilter(
    key: zio.aws.ssm.model.DocumentFilterKey,
    value: DocumentFilterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentFilter = {
    import DocumentFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentFilter
      .builder()
      .key(key.unwrap)
      .value(DocumentFilterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentFilter.ReadOnly =
    zio.aws.ssm.model.DocumentFilter.wrap(buildAwsValue())
}
object DocumentFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentFilter =
      zio.aws.ssm.model.DocumentFilter(key, value)
    def key: zio.aws.ssm.model.DocumentFilterKey
    def value: DocumentFilterValue
    def getKey: ZIO[Any, Nothing, zio.aws.ssm.model.DocumentFilterKey] =
      ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, DocumentFilterValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentFilter
  ) extends zio.aws.ssm.model.DocumentFilter.ReadOnly {
    override val key: zio.aws.ssm.model.DocumentFilterKey =
      zio.aws.ssm.model.DocumentFilterKey.wrap(impl.key())
    override val value: DocumentFilterValue =
      zio.aws.ssm.model.primitives.DocumentFilterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentFilter
  ): zio.aws.ssm.model.DocumentFilter.ReadOnly = new Wrapper(impl)
}
