package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentDisplayName,
  DocumentARN,
  DocumentVersion,
  DateTime,
  DocumentSchemaVersion,
  DocumentAuthor,
  DocumentOwner,
  DocumentVersionName,
  TargetType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DocumentIdentifier(
    name: Option[DocumentARN] = None,
    createdDate: Option[DateTime] = None,
    displayName: Option[DocumentDisplayName] = None,
    owner: Option[DocumentOwner] = None,
    versionName: Option[DocumentVersionName] = None,
    platformTypes: Option[Iterable[zio.aws.ssm.model.PlatformType]] = None,
    documentVersion: Option[DocumentVersion] = None,
    documentType: Option[zio.aws.ssm.model.DocumentType] = None,
    schemaVersion: Option[DocumentSchemaVersion] = None,
    documentFormat: Option[zio.aws.ssm.model.DocumentFormat] = None,
    targetType: Option[TargetType] = None,
    tags: Option[Iterable[zio.aws.ssm.model.Tag]] = None,
    requires: Option[Iterable[zio.aws.ssm.model.DocumentRequires]] = None,
    reviewStatus: Option[zio.aws.ssm.model.ReviewStatus] = None,
    author: Option[DocumentAuthor] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentIdentifier = {
    import DocumentIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentIdentifier
      .builder()
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        createdDate.map(value => DateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        displayName.map(value =>
          DocumentDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        owner.map(value => DocumentOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        platformTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformTypesWithStrings)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(documentType.map(value => value.unwrap))(_.documentType)
      .optionallyWith(
        schemaVersion.map(value =>
          DocumentSchemaVersion.unwrap(value): java.lang.String
        )
      )(_.schemaVersion)
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .optionallyWith(
        targetType.map(value => TargetType.unwrap(value): java.lang.String)
      )(_.targetType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        requires.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requires)
      .optionallyWith(reviewStatus.map(value => value.unwrap))(_.reviewStatus)
      .optionallyWith(
        author.map(value => DocumentAuthor.unwrap(value): java.lang.String)
      )(_.author)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentIdentifier.ReadOnly =
    zio.aws.ssm.model.DocumentIdentifier.wrap(buildAwsValue())
}
object DocumentIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentIdentifier =
      zio.aws.ssm.model.DocumentIdentifier(
        name.map(value => value),
        createdDate.map(value => value),
        displayName.map(value => value),
        owner.map(value => value),
        versionName.map(value => value),
        platformTypes.map(value => value),
        documentVersion.map(value => value),
        documentType.map(value => value),
        schemaVersion.map(value => value),
        documentFormat.map(value => value),
        targetType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requires.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reviewStatus.map(value => value),
        author.map(value => value)
      )
    def name: Option[DocumentARN]
    def createdDate: Option[DateTime]
    def displayName: Option[DocumentDisplayName]
    def owner: Option[DocumentOwner]
    def versionName: Option[DocumentVersionName]
    def platformTypes: Option[List[zio.aws.ssm.model.PlatformType]]
    def documentVersion: Option[DocumentVersion]
    def documentType: Option[zio.aws.ssm.model.DocumentType]
    def schemaVersion: Option[DocumentSchemaVersion]
    def documentFormat: Option[zio.aws.ssm.model.DocumentFormat]
    def targetType: Option[TargetType]
    def tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def requires: Option[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]]
    def reviewStatus: Option[zio.aws.ssm.model.ReviewStatus]
    def author: Option[DocumentAuthor]
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDisplayName: ZIO[Any, AwsError, DocumentDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getOwner: ZIO[Any, AwsError, DocumentOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getPlatformTypes
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.PlatformType]] =
      AwsError.unwrapOptionField("platformTypes", platformTypes)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getDocumentType: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentType] =
      AwsError.unwrapOptionField("documentType", documentType)
    def getSchemaVersion: ZIO[Any, AwsError, DocumentSchemaVersion] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
    def getTargetType: ZIO[Any, AwsError, TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRequires: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentRequires.ReadOnly
    ]] = AwsError.unwrapOptionField("requires", requires)
    def getReviewStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ReviewStatus] =
      AwsError.unwrapOptionField("reviewStatus", reviewStatus)
    def getAuthor: ZIO[Any, AwsError, DocumentAuthor] =
      AwsError.unwrapOptionField("author", author)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentIdentifier
  ) extends zio.aws.ssm.model.DocumentIdentifier.ReadOnly {
    override val name: Option[DocumentARN] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val createdDate: Option[DateTime] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val displayName: Option[DocumentDisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.ssm.model.primitives.DocumentDisplayName(value))
    override val owner: Option[DocumentOwner] = scala
      .Option(impl.owner())
      .map(value => zio.aws.ssm.model.primitives.DocumentOwner(value))
    override val versionName: Option[DocumentVersionName] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val platformTypes: Option[List[zio.aws.ssm.model.PlatformType]] =
      scala
        .Option(impl.platformTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PlatformType.wrap(item)
          }.toList
        )
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val documentType: Option[zio.aws.ssm.model.DocumentType] = scala
      .Option(impl.documentType())
      .map(value => zio.aws.ssm.model.DocumentType.wrap(value))
    override val schemaVersion: Option[DocumentSchemaVersion] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentSchemaVersion(value))
    override val documentFormat: Option[zio.aws.ssm.model.DocumentFormat] =
      scala
        .Option(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
    override val targetType: Option[TargetType] = scala
      .Option(impl.targetType())
      .map(value => zio.aws.ssm.model.primitives.TargetType(value))
    override val tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.Tag.wrap(item)
        }.toList
      )
    override val requires
        : Option[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]] = scala
      .Option(impl.requires())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.DocumentRequires.wrap(item)
        }.toList
      )
    override val reviewStatus: Option[zio.aws.ssm.model.ReviewStatus] = scala
      .Option(impl.reviewStatus())
      .map(value => zio.aws.ssm.model.ReviewStatus.wrap(value))
    override val author: Option[DocumentAuthor] = scala
      .Option(impl.author())
      .map(value => zio.aws.ssm.model.primitives.DocumentAuthor(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentIdentifier
  ): zio.aws.ssm.model.DocumentIdentifier.ReadOnly = new Wrapper(impl)
}
