package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.DocumentReviewComment
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DocumentReviewCommentSource(
    `type`: Option[zio.aws.ssm.model.DocumentReviewCommentType] = None,
    content: Option[DocumentReviewComment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentReviewCommentSource = {
    import DocumentReviewCommentSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentReviewCommentSource
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        content.map(value =>
          DocumentReviewComment.unwrap(value): java.lang.String
        )
      )(_.content)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentReviewCommentSource.ReadOnly =
    zio.aws.ssm.model.DocumentReviewCommentSource.wrap(buildAwsValue())
}
object DocumentReviewCommentSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentReviewCommentSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentReviewCommentSource =
      zio.aws.ssm.model.DocumentReviewCommentSource(
        `type`.map(value => value),
        content.map(value => value)
      )
    def `type`: Option[zio.aws.ssm.model.DocumentReviewCommentType]
    def content: Option[DocumentReviewComment]
    def getType
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentReviewCommentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getContent: ZIO[Any, AwsError, DocumentReviewComment] =
      AwsError.unwrapOptionField("content", content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentReviewCommentSource
  ) extends zio.aws.ssm.model.DocumentReviewCommentSource.ReadOnly {
    override val `type`: Option[zio.aws.ssm.model.DocumentReviewCommentType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.ssm.model.DocumentReviewCommentType.wrap(value))
    override val content: Option[DocumentReviewComment] = scala
      .Option(impl.content())
      .map(value => zio.aws.ssm.model.primitives.DocumentReviewComment(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentReviewCommentSource
  ): zio.aws.ssm.model.DocumentReviewCommentSource.ReadOnly = new Wrapper(impl)
}
